unit editor;
interface
uses types,lang,menu,global_data, graph,grMainModule,wincrt,grGUI;

procedure conf_editor ();
function  open_file(var filename:string) :integer;
procedure Grid;
procedure view_all_pix;
procedure save_current_map_to_file;


implementation

function  create_file(var filename:string): boolean;
var
 f:text;
 readstr:string;
 errcode:integer;
begin
 clear_map;
 cleardisplay;

 if grtextread(getmaxx div 2-50,getmaxy div 2 - 30,'Save as:',filename) then begin
  if grtextread(getmaxx div 2-50,getmaxy div 2 - 30,'size map: ',readstr) then begin
    val(readstr,actual_size,errcode);
    if errcode<>0 then actual_size:=20;
  end else result:=false;

  assign(f,filename);
  rewrite (f);
  close(f);

  result:=true;
 end else result:=false;
end;

function  open_file(var filename:string) :integer;
var
 f:text;
 reset_ok: boolean;
 i,j: integer;
begin
 repeat
  cleardisplay;

  if grtextread(getmaxx div 2-50,getmaxy div 2 - 30,'Open file:',filename) then begin
    assign(f,filename);
    reset_ok:=false;
    {$I-}reset(f); {$i+}
    if ioresult<>0 then begin
      Button(getmaxx div 2-50,getmaxy div 2 - 30,'Error, file not found!',true, false,true);
      readkey;
    end else reset_ok:=true
  end else begin reset_ok:=true; result:=-2; end;
 until reset_ok=true;
 if result<>-2 then begin
 {$i-}
 readln(f,actual_size);
 for i:=1 to actual_size do for j:=1 to actual_size do read(f,mainmap[i,j]);
 close(f);
 {$i+}
 if ioresult<>0 then reset_ok:=false;
 if reset_ok=true then result:=0 else result:=-1;
 end;
end;

procedure Grid;
var
  bs,i, T : word;
  x2,y2:longint;
begin
  if size_of_block>4 then begin
    SetColor(color_grid);
     x2 := GetMaxX div 2;
     y2 := GetMaxY div 2;
     bs:=size_of_block ;
     T := bs div 2 * actual_size ;
     Rectangle(x2 - T, y2 - T, x2 + T, y2 + T);
     i := x2 - T;
     while (i <= x2 + T) do begin
      line(i, y2 - T, i, y2 + T);
      inc(i, bs);
     end;
     i := y2 - T;
     while (i <= y2 + T) do begin
      line (x2 - T, i, x2 + T, i);
      inc(i, bs);
     end;
   end;
end;

procedure cells_view (x,y,color:longint);
begin
  if color<> black then color:=color_cells;
  setcolor(color);
  setfillstyle(1,color);
  bar(x-size_of_cells div 2,y-size_of_cells div 2 ,x+size_of_cells div 2,y+size_of_cells div 2);
end;

procedure savetofile(filename:string);
var
 f:text; i,j:integer;
begin
     assign(f,filename);
     rewrite(f);
     writeln(f,actual_size);

     for i:=1 to actual_size do for j:= 1 to actual_size do
      write(f,mainmap[i,j],' ');

     close(f);
end;

procedure view_all_pix;
var
 bs,c,bsd2,x2,y2,i,j,tx,ty,t:integer;

begin
 bs:=size_of_block ; {block size!}
 T := bs div 2 * actual_size ;
 x2 := GetMaxX div 2;
 y2 := GetMaxY div 2;
 Tx := x2 - T;
 Ty := y2 - T;
 bsd2 := bs div 2;
 setcolor(black);

 cells:=0;
 for i:=1 to actual_size do for j:=1 to actual_size do
    if mainmap[i,j]=1 then begin
     inc(cells);
     cells_view(Tx + bs * i - bsd2, Ty + bs * j - bsd2,green);
    end else begin
     cells_view(Tx + bs * i - bsd2, Ty + bs * j - bsd2,black);
    end;

end;

procedure view_info(x,y:integer);
var
  outstr:string;
begin
  setfillstyle(1,black);
  setcolor(black);
  bar(0,0,150,100);
  setcolor(white);
  outtextxy(10,10,dialogs[6]+' [s]');
  outtextxy(10,20,dialogs[2]+' [Shift+s]');
  outtextxy(10,30,dialogs[7]);
  outtextxy(10,40,dialogs[8]);
  outtextxy(10,50,dialogs[9]);

  setcolor(green);
  str(x,outstr);
  outtextxy(10,70,dialogs[10]+' '+dialogs[11]+' '+outstr);
  str(y,outstr);
  outtextxy(10,80,dialogs[10]+' '+dialogs[12]+' '+outstr);

end;

procedure save_current_map_to_file;
var
 fn:string;
begin

  cleardisplay;
  grtextread(getmaxx div 2, getmaxy div 2, dialogs[2],fn);
  savetofile(fn);
  grid;
  view_all_pix;

end;

procedure greditors(filename:string);
var
 bs,c,bsd2,x2,k,m,y2,i,j,tx,ty,t:integer;
 select:byte;
begin

 Grid;
 bs:=size_of_block ; {block size!}
 T := bs div 2 * actual_size ;
 x2 := GetMaxX div 2;
 y2 := GetMaxY div 2;
 Tx := x2 - T;
 Ty := y2 - T;
 bsd2 := bs div 2;
 view_all_pix;
 i:=actual_size div 2; j:=actual_size div 2;

 repeat
    view_info(i,j);
    setcolor(blue);
    rectangle(Tx + bs * i - bsd2-size_of_cells div 2-1, Ty + bs * j - bsd2 -size_of_cells div 2-1,Tx + bs * i - bsd2+size_of_cells div 2+1, Ty + bs * j - bsd2+size_of_cells div 2+1);
  select:=ord(wincrt.readkey);

  if select=0 then select:=ord(wincrt.readkey);
    setcolor(black);
    rectangle(Tx + bs * i - bsd2-size_of_cells div 2-1, Ty + bs * j - bsd2 -size_of_cells div 2-1,Tx + bs * i - bsd2+size_of_cells div 2+1, Ty + bs * j - bsd2+size_of_cells div 2+1);
  case select of
      114: begin
             for k:=1 to actual_size do for m:=1 to actual_size do begin
                 if random(2)=1 then begin
                    mainmap[k,m]:=1;
                    cells_view(Tx + bs * k - bsd2, Ty + bs * m - bsd2,green);
                 end;
             end;
           end;
      72: if j>1 then dec(j);
      80: if j<actual_size then inc(j);
      75: if i>1 then dec(i);
      77: if i<actual_size then inc(i);
      32,115: savetofile(filename);
      83: save_current_map_to_file;
      13: begin
          if mainmap[i,j]=0 then begin
             mainmap[i,j]:=1;
             c := green;
          end else begin
              mainmap[i,j]:=0;
              c:=black;
          end;
          cells_view(Tx + bs * i - bsd2, Ty + bs * j - bsd2,c);
          end;
  end
 until select=27;
end;


procedure conf_editor ();
var
   select_it: counter;
   filename:string;
begin
    cleardisplay;
    repeat


     select_it:= show_menu(menu_editor,3,1,style_hor);
     case select_it of
     1: begin
        if create_file(filename) then  greditors(filename);
      end;
     2: begin
             if open_file(filename)=0 then begin

               greditors(filename) ;

             end else begin
                 Button(getmaxx div 2-50,getmaxy div 2 - 30,'Error IO, bad file struct', true, false,true);
                 readkey;
                 pause;
             end;
        end;
     end;
   until select_it = 3;
end;
begin end.
